/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.tests.dao;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IDao;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.ModelUnitVO;
import com.quantumdata.sct.dao.vo.UnitVO;
import com.quantumdata.sct.util.keygen.KeyGeneratorFactory;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class UnitDAOTest
extends TestCase {
    private IDao dao;
    private boolean bInitialize;

    public UnitDAOTest(String string) {
        super(string);
    }

    protected void setUp() {
        try {
            System.setProperty(XMLDAOFactory.dataFileEnv, "." + System.getProperty("file.separator") + "Properties.props");
            this.dao = XMLDAOFactory.getModelUnitDAO();
            this.bInitialize = true;
        }
        catch (Exception exception) {
            this.bInitialize = false;
        }
    }

    private UnitVO getUnitVO() {
        UnitVO unitVO = new UnitVO();
        unitVO.setId(KeyGeneratorFactory.getModelKG().generateUniqueKey());
        unitVO.setSerialNumber("1234251234132");
        return unitVO;
    }

    public void insertTest() {
        boolean bl = false;
        ModelUnitVO modelUnitVO = new ModelUnitVO();
        String string = KeyGeneratorFactory.getModelKG().generateUniqueKey();
        modelUnitVO.setId(string);
        modelUnitVO.setLastUpdate(System.currentTimeMillis());
        ArrayList<UnitVO> arrayList = new ArrayList<UnitVO>();
        arrayList.add(this.getUnitVO());
        arrayList.add(this.getUnitVO());
        try {
            this.dao.add(modelUnitVO);
            this.dao.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        UnitDAOTest.assertEquals(bl, false);
    }

    public void readAllTest() {
        boolean bl = false;
        try {
            IPersistable[] iPersistableArray = this.dao.readAll();
            System.out.println(iPersistableArray.length);
            if (iPersistableArray.length > 0) {
                for (int i = 0; i < iPersistableArray.length; ++i) {
                    IPersistable iPersistable = iPersistableArray[i];
                    System.out.println(iPersistable.getId());
                }
            } else {
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        UnitDAOTest.assertEquals(bl, false);
    }

    public void readTest() {
        boolean bl = false;
        String string = "ID1";
        try {
            IPersistable iPersistable = this.dao.read(string);
            bl = !iPersistable.getId().equals(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl = true;
        }
        UnitDAOTest.assertEquals(bl, false);
    }

    public static Test suite() {
        TestSuite testSuite = new TestSuite();
        testSuite.addTest(new UnitDAOTest("readTest"));
        testSuite.addTest(new UnitDAOTest("readAllTest"));
        testSuite.addTest(new UnitDAOTest("insertTest"));
        return testSuite;
    }
}

